/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.velocity;

import com.estrelsteel.engine2.point.AbstractedPoint;
import com.estrelsteel.engine2.velocity.Friction;
import com.estrelsteel.engine2.velocity.Velocity;

public class DecayingVelocity
extends Velocity {
    private double startVelocityX;
    private double startVelocityY;
    private Friction friction;

    public DecayingVelocity(double velocity, Friction friction) {
        super(velocity);
        this.startVelocityX = velocity;
        this.startVelocityY = velocity;
        this.friction = friction;
    }

    public double getStartVelocityX() {
        return this.startVelocityX;
    }

    public double getStartVelocityY() {
        return this.startVelocityY;
    }

    public Friction getFriction() {
        return this.friction;
    }

    public boolean equals(Object other) {
        return this.startVelocityX == ((DecayingVelocity)other).getStartVelocityX() && this.startVelocityY == ((DecayingVelocity)other).getStartVelocityY() && super.equals(other);
    }

    @Override
    public AbstractedPoint applyVelocity(AbstractedPoint point) {
        point = super.applyVelocity(point);
        this.setVelocityX(this.getVelocityX() - this.friction.getFriction());
        this.setVelocityY(this.getVelocityY() - this.friction.getFriction());
        return point;
    }

    @Override
    public void setVelocityX(double velocity) {
        this.startVelocityX = velocity;
        super.setVelocityX(velocity);
    }

    @Override
    public void setVelocityY(double velocity) {
        this.startVelocityY = velocity;
        super.setVelocityY(velocity);
    }

    public void setStartVelocityX(double startVelocity) {
        this.startVelocityX = startVelocity;
    }

    public void setStartVelocityY(double startVelocity) {
        this.startVelocityY = startVelocity;
    }

    public void setFriction(Friction friction) {
        this.friction = friction;
    }
}

