/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.sound;

import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.sound.SFX;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sound
implements Saveable {
    private String name;
    private String src;
    private Clip clip;
    private float vol;

    public Sound(String name, String src) {
        this.name = name;
        this.src = src;
    }

    public String getName() {
        return this.name;
    }

    public String getSRC() {
        return this.src;
    }

    public Clip getClip() {
        return this.clip;
    }

    public synchronized void play() {
        if (this.clip != null && this.clip.isRunning()) {
            FloatControl volume = (FloatControl)SFX.getSounds().get(1).getClip().getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue(this.vol);
        }
        if (this.clip == null || !this.clip.isRunning()) {
            try {
                File file = new File(this.src);
                this.clip = AudioSystem.getClip();
                AudioInputStream ais = AudioSystem.getAudioInputStream(file);
                this.clip.open(ais);
                FloatControl volume = (FloatControl)SFX.getSounds().get(1).getClip().getControl(FloatControl.Type.MASTER_GAIN);
                volume.setValue(this.vol);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
            this.clip.flush();
            this.clip.start();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSRC(String src) {
        this.src = src;
    }

    public void setClip(Clip clip) {
        this.clip = clip;
    }

    @Override
    public String getIdentifier() {
        return "SFX";
    }

    @Override
    public Sound load(GameFile file, int line) {
        String[] args = file.getLines().get(line).split(" ");
        if (args[0].trim().equalsIgnoreCase(this.getIdentifier())) {
            this.name = args[1].trim();
            this.src = String.valueOf(GameFile.getDataPath()) + args[2].trim();
            this.vol = Float.parseFloat(args[3].trim());
        }
        return this;
    }

    @Override
    public GameFile save(GameFile file) {
        this.src = this.src.substring(GameFile.getDataPath().length());
        file.getLines().add(String.valueOf(this.getIdentifier()) + " " + this.name + " " + this.src + " " + this.vol);
        return file;
    }
}

