/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.shape.rectangle;

import com.estrelsteel.engine2.point.AbstractedPoint;
import com.estrelsteel.engine2.shape.Rotation;

public class AbstractedRectangle {
    private AbstractedPoint top;
    private AbstractedPoint bottom;
    private Rotation rotation;

    public AbstractedRectangle(AbstractedPoint top, AbstractedPoint bottom) {
        this.top = top;
        this.bottom = bottom;
        this.rotation = new Rotation(0.0);
    }

    public AbstractedRectangle(AbstractedPoint top, AbstractedPoint bottom, Rotation rotation) {
        this.top = top;
        this.bottom = bottom;
        this.rotation = rotation;
    }

    public AbstractedPoint getTop() {
        return this.top;
    }

    public AbstractedPoint getBottom() {
        return this.bottom;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public double getWidth() {
        return this.top.getWidth(this.bottom);
    }

    public double getHeight() {
        return this.top.getHeight(this.bottom);
    }

    public double getX() {
        return this.top.getX();
    }

    public double getY() {
        return this.top.getY();
    }

    public boolean equals(Object other) {
        return this.top.equals(((AbstractedRectangle)other).getTop()) && this.bottom.equals(((AbstractedRectangle)other).getBottom());
    }

    public void setTop(AbstractedPoint top) {
        this.top = top;
    }

    public void setBottom(AbstractedPoint bottom) {
        this.bottom = bottom;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void setX(double x) {
        this.top.setX(x);
    }

    public void setY(double y) {
        this.top.setY(y);
    }
}

