/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.file;

import com.estrelsteel.engine2.Engine2;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class GameFile {
    private String path;
    private ArrayList<String> lines;

    public GameFile(String path) {
        this.path = path;
        this.lines = new ArrayList();
    }

    public static String getCurrentPath() {
        File f = new File(System.getProperty("java.class.path"));
        return f.getParentFile().getAbsolutePath().toString();
    }

    public static String getDataPath() {
        if (Engine2.development) {
            return Engine2.devPath;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            return String.valueOf(System.getProperty("user.home")) + "/AppData/Roaming";
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            return String.valueOf(System.getProperty("user.home")) + "/Library/Application Support";
        }
        if (System.getProperty("os.name").startsWith("Linux")) {
            return String.valueOf(System.getProperty("user.home"));
        }
        return "";
    }

    public String getPath() {
        return this.path;
    }

    public ArrayList<String> getLines() {
        return this.lines;
    }

    public ArrayList<String> readFile() throws IOException {
        FileReader file = new FileReader(this.path);
        BufferedReader br = new BufferedReader(file);
        ArrayList<String> lines = new ArrayList<String>();
        String line = br.readLine();
        while (line != null) {
            lines.add(line);
            line = br.readLine();
        }
        return lines;
    }

    public void updateLines() throws IOException {
        this.lines = this.readFile();
    }

    public void saveFile() throws IOException {
        FileWriter fw = new FileWriter(this.path);
        BufferedWriter bw = new BufferedWriter(fw);
        for (String line : this.lines) {
            bw.write(String.valueOf(line) + "\n");
        }
        bw.flush();
        bw.close();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLines(ArrayList<String> lines) {
        this.lines = lines;
    }
}

