/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.packets;

import com.estrelsteel.packets.Game;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Server
extends Thread {
    private DatagramSocket socket;
    Game game;
    List<String> onlinePlayers = new ArrayList<String>();
    List<InetAddress> onlinePlayersIP = new ArrayList<InetAddress>();
    List<String> onlinePlayersPort = new ArrayList<String>();
    int maxPlayers = 4;
    int minPlayers = 2;
    int port;
    int clientBuild = 6;
    int seed = 4;

    public Server(Game game, int maxPlayers, int port) {
        int randomNum;
        this.game = game;
        this.maxPlayers = maxPlayers;
        this.port = port;
        Random random = new Random();
        int range = 1999999999;
        this.seed = randomNum = random.nextInt(range) + -999999999;
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            byte[] data = new byte[1024];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            try {
                this.socket.receive(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String message = new String(packet.getData()).trim();
            if (message.startsWith("000")) {
                System.out.println("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "is attempting to join.");
                this.game.addToConsole("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "is attempting to join.");
                if (this.game.stringtoint(message.substring(3, 5)) > this.clientBuild) {
                    System.out.println("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "forced disconnect, outdated server.");
                    this.game.addToConsole("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "forced disconnect, outdated server");
                    this.sendData("004".getBytes(), packet.getAddress(), packet.getPort());
                } else if (this.game.stringtoint(message.substring(3, 5)) < this.clientBuild) {
                    System.out.println("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "forced disconnect, outdated client.");
                    this.game.addToConsole("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "forced disconnect, outdated client.");
                    this.sendData("003".getBytes(), packet.getAddress(), packet.getPort());
                } else if (this.onlinePlayers.size() >= this.maxPlayers) {
                    System.out.println("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "forced disconnect, too many players.");
                    this.game.addToConsole("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "forced disconnect, too many players.");
                    this.sendData("002".getBytes(), packet.getAddress(), packet.getPort());
                } else {
                    boolean onlinePlayer = false;
                    for (String s : this.onlinePlayers) {
                        if (!message.substring(5).equalsIgnoreCase(s)) continue;
                        onlinePlayer = true;
                        return;
                    }
                    if (onlinePlayer) {
                        System.out.println("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "is already online!");
                        this.game.addToConsole("CLIENT[" + packet.getAddress() + ":" + packet.getPort() + "] " + "is already online!");
                        this.sendData("001".getBytes(), packet.getAddress(), packet.getPort());
                    } else {
                        System.out.println(String.valueOf(message.substring(5)) + "[" + packet.getAddress() + ":" + packet.getPort() + "] " + "has joined!");
                        this.game.addToConsole(String.valueOf(message.substring(5)) + "[" + packet.getAddress() + ":" + packet.getPort() + "] " + "has joined!");
                        int i = 0;
                        while (i < this.onlinePlayers.size()) {
                            this.sendData(("005" + message.substring(5)).getBytes(), this.onlinePlayersIP.get(i), this.game.stringtoint(this.onlinePlayersPort.get(i)));
                            this.sendData(("005" + this.onlinePlayers.get(i)).getBytes(), packet.getAddress(), packet.getPort());
                            ++i;
                        }
                        this.sendData(("019" + this.seed).getBytes(), packet.getAddress(), packet.getPort());
                        this.onlinePlayers.add(message.substring(5));
                        this.onlinePlayersIP.add(packet.getAddress());
                        this.onlinePlayersPort.add("" + packet.getPort());
                    }
                }
            } else if (message.startsWith("001")) {
                System.out.println(String.valueOf(message.substring(3)) + "[" + packet.getAddress() + ":" + packet.getPort() + "] " + "has disconnected.");
                this.game.addToConsole(String.valueOf(message.substring(3)) + "[" + packet.getAddress() + ":" + packet.getPort() + "] " + "has disconnected.");
                this.onlinePlayers.remove(message.substring(3));
                this.onlinePlayersIP.remove(packet.getAddress());
                this.onlinePlayersPort.remove("" + packet.getPort());
                if (this.onlinePlayers.size() >= 1 && this.onlinePlayersIP.size() >= 1 && this.onlinePlayersPort.size() >= 1) {
                    int i = 0;
                    while (i < this.onlinePlayers.size()) {
                        this.sendData(("006" + message.substring(3)).getBytes(), this.onlinePlayersIP.get(i), this.game.stringtoint(this.onlinePlayersPort.get(i)));
                        ++i;
                    }
                }
            }
            if (!message.trim().equalsIgnoreCase("ping")) continue;
            this.sendData("pong".getBytes(), packet.getAddress(), packet.getPort());
        }
    }

    public void sendData(byte[] data, InetAddress ipAddress, int port) {
        DatagramPacket packet = new DatagramPacket(data, data.length, ipAddress, port);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

