/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.packets;

import com.estrelsteel.packets.Client;
import com.estrelsteel.packets.Game;
import com.estrelsteel.packets.Server;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class Packets {
    private static Server socketServer;
    private Client socketClient;
    private Client client;
    private boolean runServer = true;

    public static void main(String[] args) {
        Game game = new Game(socketServer);
        game.start();
        new Packets().start(game);
    }

    public void start(Game game) {
        String input = "y";
        if (input.equalsIgnoreCase("y")) {
            this.runServer = true;
            try {
                InetAddress thisIp = InetAddress.getLocalHost();
                System.out.println("Your LOCAL server ip is: " + thisIp);
                game.addToConsole("Your LOCAL server ip is: " + thisIp);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else {
            this.runServer = false;
        }
        game.addToConsole("");
        game.addToConsole("This server is compatible with GNSP v0.6a-ALPHA or Build 07!");
        game.addToConsole("Other client versions will not work with this server!");
        game.addToConsole("");
        int maxPlayers = this.stringtoint(JOptionPane.showInputDialog("Max Players?"));
        if (maxPlayers == -256) {
            game.addToConsole("Not valid max players. Setting to 4.");
            maxPlayers = 4;
        } else {
            game.addToConsole("Max players set to " + maxPlayers + ".");
        }
        int port = this.stringtoint(JOptionPane.showInputDialog("Server Port?"));
        if (port == -256) {
            game.addToConsole("Not valid port. Setting to 5005.");
            port = 5005;
        } else {
            game.addToConsole("Port set to " + port + ".");
        }
        socketServer = new Server(game, maxPlayers, port);
        if (this.runServer) {
            socketServer.start();
        }
        System.out.println("Running on port " + port + "...");
        game.addToConsole("Running on port " + port + "...");
    }

    public int stringtoint(String s) {
        int i;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            i = -256;
        }
        return i;
    }
}

