/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.packets;

import com.estrelsteel.packets.InputHandler;
import com.estrelsteel.packets.Server;
import com.estrelsteel.packets.WindowHandler;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class Game
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    private JFrame frame;
    private BufferedImage image = new BufferedImage(160, 117, 1);
    private int[] pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    public static final int WIDTH = 160;
    public static final int HEIGHT = 117;
    public static final int SCALE = 3;
    public static final String NAME = "GNSP Server 0.2a";
    public boolean running = false;
    public int tickCount = 0;
    public int frames;
    public boolean showLine = true;
    public String text = "";
    public InputHandler input = new InputHandler(this);
    public WindowHandler window;
    public JTextField field;
    public static List<String> consoleInfo = new ArrayList<String>();

    public Game(Server server) {
        this.window = new WindowHandler(this, server);
        this.addKeyListener(this.input);
        this.setFocusable(true);
        this.setMinimumSize(new Dimension(480, 351));
        this.setMaximumSize(new Dimension(480, 351));
        this.setPreferredSize(new Dimension(480, 351));
        this.frame = new JFrame(NAME);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this.window);
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this, "Center");
        this.field = new JTextField(20);
        this.field.setMinimumSize(new Dimension(480, 40));
        this.field.setMaximumSize(new Dimension(480, 40));
        this.field.setPreferredSize(new Dimension(480, 40));
        this.field.setLocation(0, 360);
        this.frame.setSize(400, 400);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public synchronized void start() {
        this.running = true;
        new Thread(this).start();
    }

    public synchronized void stop() {
        this.running = false;
    }

    @Override
    public void run() {
        long lastTime = System.nanoTime();
        double nsPerTick = 1.6666666666666666E7;
        int ticks = 0;
        this.frames = 0;
        long lastTimer = System.currentTimeMillis();
        double delta = 0.0;
        while (this.running) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / nsPerTick;
            lastTime = now;
            boolean shouldRender = true;
            while (delta >= 1.0) {
                ++ticks;
                this.tick();
                delta -= 1.0;
                shouldRender = true;
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (shouldRender) {
                ++this.frames;
                this.render();
            }
            if (System.currentTimeMillis() - lastTimer < 1000L) continue;
            lastTimer += 1000L;
            ticks = 0;
            this.frames = 0;
            boolean bl = this.showLine = !this.showLine;
        }
    }

    public void tick() {
        ++this.tickCount;
        int i = 0;
        while (i < this.pixels.length) {
            this.pixels[i] = i + this.tickCount;
            ++i;
        }
    }

    public void render() {
        BufferStrategy bs = this.getBufferStrategy();
        if (bs == null) {
            this.createBufferStrategy(3);
            return;
        }
        Graphics g = bs.getDrawGraphics();
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(5, this.getHeight() - 30, this.getWidth() - 10, 20);
        g.setColor(Color.BLACK);
        int pos = 1;
        int i = consoleInfo.size() - 1;
        while (i >= 0) {
            String s = consoleInfo.get(i);
            g.drawString(s, 5, this.getHeight() - 30 - pos * 20);
            ++pos;
            --i;
        }
        String finalText = this.showLine ? String.valueOf(this.text) + "|" : this.text;
        g.drawString(finalText, 7, this.getHeight() - 17);
        g.dispose();
        bs.show();
    }

    public int stringtoint(String s) {
        int i;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            i = -256;
        }
        return i;
    }

    public void addToConsole(String text) {
        consoleInfo.add(text);
    }
}

