/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.packets;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class Client
extends Thread {
    private InetAddress ipAddress;
    private DatagramSocket socket;
    private int port = 5005;
    List<String> onlinePlayers = new ArrayList<String>();

    public Client(String ipAddress, int port) {
        try {
            this.socket = new DatagramSocket();
            this.port = port;
            this.ipAddress = InetAddress.getByName(ipAddress);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            byte[] data = new byte[1024];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            try {
                this.socket.receive(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String message = new String(packet.getData());
            System.out.println("SERVER > " + message);
            if (message.startsWith("000")) {
                System.out.println("SERVER > Forced disconnect, server closed!");
            } else if (message.startsWith("001")) {
                System.out.println("SERVER > Forced disconnect, username in use!");
            } else if (message.startsWith("002")) {
                System.out.println("SERVER > Forced disconnect, over max players!");
            } else if (message.startsWith("003")) {
                System.out.println("SERVER > Forced disconnect, outdated client!");
            } else if (message.startsWith("004")) {
                System.out.println("SERVER > Forced disconnect, outdated server!");
            } else if (message.startsWith("005")) {
                System.out.println("SERVER > " + message.substring(3) + " joined the game!");
                this.onlinePlayers.add(message.substring(3));
            } else if (message.startsWith("006")) {
                System.out.println("SERVER > " + message.substring(3) + " left the game!");
                this.onlinePlayers.remove(message.substring(3));
            }
            if (!message.trim().equalsIgnoreCase("pong")) continue;
            this.sendData("Computer 2 Pong Reply".getBytes());
        }
    }

    public void sendData(byte[] data) {
        DatagramPacket packet = new DatagramPacket(data, data.length, this.ipAddress, this.port);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

