/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.game3.world;

import com.estrelsteel.game3.block.Block;
import com.estrelsteel.game3.block.grass.Grass;
import com.estrelsteel.game3.block.mountain.Mountain;
import com.estrelsteel.game3.block.tree.Tree;
import com.estrelsteel.game3.block.water.Water;
import com.estrelsteel.game3.character.player.Player;
import com.estrelsteel.game3.font.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class World {
    List<Block> worldB = new ArrayList<Block>();
    List<Font> worldF = new ArrayList<Font>();
    int seed;

    public List<Block> getBlockWorld() {
        return this.worldB;
    }

    public List<Font> getFontWorld() {
        return this.worldF;
    }

    public Block getBlock(int num) {
        return this.worldB.get(num);
    }

    public void addBlock(Block block) {
        this.worldB.add(block);
    }

    public void removeBlock(int x, int y) {
        for (Block b : this.worldB) {
            if (b.getX() != x || b.getY() != y) continue;
            this.worldB.remove(b);
        }
    }

    public int getSeed() {
        return this.seed;
    }

    public Block genBlockSeed(int x, int y, int w, int h) {
        int genNum = this.seed * (x ^ 2 + y ^ 2) - (h ^ 2 - w ^ 2);
        if (genNum % 5 == 0 || genNum % 3 == 0) {
            Tree tree = new Tree(this, x, y, w, h, new ArrayList<String>(), 1.0);
            tree.genData();
            return tree;
        }
        if (genNum % 11 == 0 || genNum == 13) {
            Mountain mount = new Mountain(this, x, y, w, h, new ArrayList<String>(), 1.0);
            mount.genData();
            return mount;
        }
        if (genNum % 7 == 0) {
            Water water = new Water(this, x, y, w, h, new ArrayList<String>(), 1.0);
            water.genData();
            return water;
        }
        Grass grass = new Grass(this, x, y, w, h, new ArrayList<String>(), 1.0);
        grass.genData();
        return grass;
    }

    public Font getFont(int num) {
        return this.worldF.get(num);
    }

    public void addFont(Font font) {
        this.worldF.add(font);
    }

    public List<String> getBlockWorldData(Player p) {
        List<String> blockData = null;
        int i = 0;
        while (i < this.worldB.size()) {
            blockData = this.worldB.get(i).getBlockCollisionData(p);
            if (blockData != null) break;
            ++i;
        }
        return blockData;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void generateSeed(int min, int max) {
        int randomNum;
        Random random = new Random();
        int range = max - min + 1;
        this.seed = randomNum = random.nextInt(range) + min;
    }

    public void createWorld(int x1, int y1, int x2, int y2) {
        int x = x1;
        while (x < x2) {
            int y = y1;
            while (y < y2) {
                Block tile = this.genBlockSeed(x, y, 20, 20);
                this.addBlock(tile);
                y += 20;
            }
            x += 20;
        }
    }
}

