/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.game3.net;

import com.estrelsteel.game3.Game;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class Client
extends Thread {
    private InetAddress ipAddress;
    private DatagramSocket socket;
    private int port = 5005;
    List<String> onlinePlayers = new ArrayList<String>();
    Game game;
    public boolean issue = false;

    public Client(String ipAddress, int port, Game game) {
        this.game = game;
        try {
            this.socket = new DatagramSocket();
            this.port = port;
            this.ipAddress = InetAddress.getByName(ipAddress);
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.issue = true;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            this.issue = true;
        }
    }

    @Override
    public void run() {
        while (true) {
            byte[] data = new byte[1024];
            DatagramPacket packet = new DatagramPacket(data, data.length);
            try {
                this.socket.receive(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String message = new String(packet.getData());
            System.out.println("SERVER > " + message);
            if (message.startsWith("000")) {
                System.out.println("SERVER > Forced disconnect, server closed!");
            } else if (message.startsWith("001")) {
                System.out.println("SERVER > Forced disconnect, username in use!");
            } else if (message.startsWith("002")) {
                System.out.println("SERVER > Forced disconnect, over max players!");
            } else if (message.startsWith("003")) {
                System.out.println("SERVER > Forced disconnect, outdated client!");
            } else if (message.startsWith("004")) {
                System.out.println("SERVER > Forced disconnect, outdated server!");
            } else if (message.startsWith("005")) {
                System.out.println("SERVER > " + message.substring(3) + " joined the game!");
                this.onlinePlayers.add(message.substring(3));
            } else if (message.startsWith("006")) {
                System.out.println("SERVER > " + message.substring(3) + " left the game!");
                this.onlinePlayers.remove(message.substring(3));
            } else if (message.startsWith("019")) {
                System.out.println("SERVER > " + message.substring(3) + " is the seed!");
                this.game.world.setSeed(this.game.stringtoint(message.substring(3).trim()));
                this.game.world.createWorld(60, -20, 420, 420);
            } else if (message.startsWith("020")) {
                int yLoc = message.indexOf("y");
                int xLoc = 3;
                String x = message.substring(xLoc, yLoc).trim();
                String y = message.substring(yLoc).trim();
                System.out.println("SERVER > Deleting tile at " + x + ", " + y + "!");
                this.game.world.removeBlock(this.game.stringtoint(x), this.game.stringtoint(y));
            }
            if (!message.trim().equalsIgnoreCase("pong")) continue;
            this.sendData("Computer 2 Pong Reply".getBytes());
        }
    }

    public void sendData(byte[] data) {
        DatagramPacket packet = new DatagramPacket(data, data.length, this.ipAddress, this.port);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

