/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.game3.block;

import com.estrelsteel.game3.Game;
import com.estrelsteel.game3.character.Character;
import com.estrelsteel.game3.character.empty.Empty;
import com.estrelsteel.game3.character.player.Player;
import com.estrelsteel.game3.location.Location;
import com.estrelsteel.game3.world.World;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public class Block
extends Location {
    int x = this.getX();
    int y = this.getY();
    double w = this.getW();
    double h = this.getH();
    List<String> data = new ArrayList<String>();
    boolean c;
    String src;
    boolean s;
    boolean transPower;
    Character owner = new Empty(this.getWorld());

    public Block(World world, int xN, int yN, double wN, double hN, String srcN, boolean cN, List<String> dataN, boolean sN, double nScale) {
        super(world, xN, yN, wN, hN, nScale);
        this.src = srcN;
        this.c = cN;
        this.s = sN;
        this.setTransPower(false);
    }

    public boolean getCollision() {
        return this.c;
    }

    public String getSRC() {
        return this.src;
    }

    public List<String> getBlockCollisionData(Player p) {
        int xP = p.getX() + this.x;
        int yP = p.getY() + this.y;
        double wP = this.w;
        double hP = this.h;
        int i = 1;
        while ((double)(i * 20) <= this.w) {
            wP = i * 20;
            hP = i * 20;
            if ((double)xP + wP >= (double)(Game.WIDTH / 2 - 5) && xP <= Game.WIDTH / 2 + 5 && (double)yP + hP >= (double)(Game.HEIGHT / 2 - 5) && yP <= Game.HEIGHT / 2 + 5) {
                return this.data;
            }
            ++i;
        }
        return null;
    }

    public List<String> getBlockData() {
        return this.data;
    }

    public void setBlockData(List<String> dataN) {
        this.data = dataN;
    }

    @Deprecated
    public void genBlockData(String type) {
        if (type == "CITY") {
            this.data.add("CITY");
            this.data.add("City");
            this.data.add("A city");
            this.data.add("CHARACTER");
        } else if (type == "TILE") {
            this.data.add("TILE");
            this.data.add("Tile");
            this.data.add("A tile");
            this.data.add("NULL");
        }
    }

    @Deprecated
    public void genBlockData(String type, String name) {
        if (type == "CITY") {
            this.data.add("CITY");
            this.data.add(name);
            this.data.add("A city");
            this.data.add("CHARACTER");
        } else if (type == "TILE") {
            this.data.add("TILE");
            this.data.add(name);
            this.data.add("A tile");
            this.data.add("NULL");
        }
    }

    @Deprecated
    public void outBlockData() {
        System.out.println(this.data.get(0));
        System.out.println(this.data.get(1));
        System.out.println(this.data.get(2));
        System.out.println(this.data.get(3));
    }

    public boolean canTransPower() {
        return this.transPower;
    }

    public void setTransPower(boolean transPower) {
        this.transPower = transPower;
    }

    public Character getOwner() {
        return this.owner;
    }

    public void setOwner(Character character) {
        this.owner = character;
    }

    public Graphics addBlock(Player p, Graphics ctx) {
        int xP = p.getX() + this.x;
        int yP = p.getY() + this.y;
        if (!(!this.s || xP >= -1 && xP <= Game.WIDTH + 1 || !((double)xP + this.w < -1.0) && !((double)xP + this.w > (double)(Game.WIDTH + 1)) || yP >= -1 && yP <= Game.HEIGHT + 1 || !((double)yP + this.h < -1.0) && !((double)yP + this.h > (double)(Game.HEIGHT + 1)))) {
            return ctx;
        }
        if (this.src == "/com/estrelsteel/game3/res/tree/tree.png") {
            ctx.drawImage(Game.treeImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.getOwner() == p && this.src == "/com/estrelsteel/game3/res/city/city.png") {
            ctx.drawImage(Game.cityOwnImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.src == "/com/estrelsteel/game3/res/city/city.png") {
            ctx.drawImage(Game.cityImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.src == "/com/estrelsteel/game3/res/tile/tile.png") {
            ctx.drawImage(Game.tileImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.getOwner() == p && this.src == "/com/estrelsteel/game3/res/power/power.png") {
            ctx.drawImage(Game.powerOwnImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.src == "/com/estrelsteel/game3/res/power/power.png") {
            ctx.drawImage(Game.powerImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.src == "/com/estrelsteel/game3/res/mountain/mountain.png") {
            ctx.drawImage(Game.mountainImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.src == "/com/estrelsteel/game3/res/grass/grass.png") {
            ctx.drawImage(Game.grassImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.src == "/com/estrelsteel/game3/res/city/city.png") {
            ctx.drawImage(Game.cityImg, xP, yP, (int)this.w, (int)this.h, null);
        } else if (this.src == "/com/estrelsteel/game3/res/water/water.png") {
            ctx.drawImage(Game.waterImg, xP, yP, (int)this.w, (int)this.h, null);
        }
        if (!this.c) {
            return ctx;
        }
        if ((xP >= 195 && xP <= 205 || (double)xP + this.w >= 195.0 && xP <= 195) && (yP >= 190 && yP <= 200 || (double)yP + this.h >= 190.0 && (double)yP + this.h <= 200.0)) {
            p.increaseUP();
        } else if ((xP >= 195 && xP <= 205 || (double)xP + this.w >= 195.0 && xP <= 195) && (yP >= 200 && yP <= 210 || (double)yP + this.h >= 200.0 && (double)yP + this.h <= 210.0)) {
            p.increaseDOWN();
        } else if ((xP >= 200 && xP <= 210 || (double)xP + this.w >= 200.0 && (double)xP + this.w <= 210.0) && (yP >= 195 && yP <= 205 || (double)yP + this.h >= 195.0 && yP <= 195)) {
            p.increaseRIGHT();
        } else if ((xP >= 190 && xP <= 200 || (double)xP + this.w >= 190.0 && (double)xP + this.w <= 200.0) && (yP >= 195 && yP <= 205 || (double)yP + this.h >= 195.0 && yP <= 195)) {
            p.increaseLEFT();
        }
        return ctx;
    }
}

