/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.game3.font;

import com.estrelsteel.game3.Game;
import com.estrelsteel.game3.Main;
import com.estrelsteel.game3.character.player.Player;
import com.estrelsteel.game3.location.Location;
import com.estrelsteel.game3.world.World;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class Font
extends Location {
    int x = this.getX();
    int y = this.getY();
    double w = this.getW();
    double h = this.getH();
    String src = "/com/estrelsteel/game3/res/font/font.png";
    int xPos = 0;
    int yPos = 0;
    double size = 10.0;
    int fontColour = 0;
    String fontPage1 = "abcdefghij";
    String fontPage2 = "klmnopqrst";
    String fontPage3 = "uvwxyz.!?,";
    String fontPage4 = "0123456789";
    String fontPage5 = "'\":;+=-%()";
    String fontPage6 = "_[]{}/\\$~*";
    String fontPage7 = "^#<>| ";

    public Font(World world, int xN, int yN, double wN, double hN, int nXPos, int nYPos, double nSize, double nScale) {
        super(world, xN, yN, wN, hN, nScale);
        this.xPos = nXPos;
        this.yPos = nYPos;
        this.size = nSize;
    }

    public int getFontColour() {
        return this.fontColour;
    }

    public void updateFontColour() {
        if (this.fontColour == 0) {
            this.src = "/com/estrelsteel/game3/res/font/font.png";
        } else if (this.fontColour == 1) {
            this.src = "/com/estrelsteel/game3/res/font/font-white.png";
        }
    }

    public void setFontColour(int fontColour) {
        this.fontColour = fontColour;
    }

    public Graphics stringFont(Graphics ctx, int x, int y, String text, double size) throws IOException {
        boolean run = true;
        text = text.toLowerCase();
        InputStream is = this.getClass().getResourceAsStream(this.src);
        BufferedImage img = ImageIO.read(is);
        int i = 0;
        while (i < text.length()) {
            BufferedImage newImg;
            run = true;
            int e = 0;
            while (e < this.fontPage1.length() && run) {
                if (text.charAt(i) == this.fontPage1.charAt(e)) {
                    run = false;
                    newImg = img.getSubimage(e * 10, 0, 10, 10);
                    ctx.drawImage(newImg, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
                }
                ++e;
            }
            e = 0;
            while (e < this.fontPage2.length() && run) {
                if (text.charAt(i) == this.fontPage2.charAt(e)) {
                    run = false;
                    newImg = img.getSubimage(e * 10, 10, 10, 10);
                    ctx.drawImage(newImg, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
                }
                ++e;
            }
            e = 0;
            while (e < this.fontPage3.length() && run) {
                if (text.charAt(i) == this.fontPage3.charAt(e)) {
                    run = false;
                    newImg = img.getSubimage(e * 10, 20, 10, 10);
                    ctx.drawImage(newImg, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
                }
                ++e;
            }
            e = 0;
            while (e < this.fontPage4.length() && run) {
                if (text.charAt(i) == this.fontPage4.charAt(e)) {
                    run = false;
                    newImg = img.getSubimage(e * 10, 30, 10, 10);
                    ctx.drawImage(newImg, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
                }
                ++e;
            }
            e = 0;
            while (e < this.fontPage5.length() && run) {
                if (text.charAt(i) == this.fontPage5.charAt(e)) {
                    run = false;
                    newImg = img.getSubimage(e * 10, 40, 10, 10);
                    ctx.drawImage(newImg, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
                }
                ++e;
            }
            e = 0;
            while (e < this.fontPage6.length() && run) {
                if (text.charAt(i) == this.fontPage6.charAt(e)) {
                    run = false;
                    newImg = img.getSubimage(e * 10, 50, 10, 10);
                    ctx.drawImage(newImg, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
                }
                ++e;
            }
            e = 0;
            while (e < this.fontPage7.length() && run) {
                if (text.charAt(i) == this.fontPage7.charAt(e)) {
                    run = false;
                    newImg = img.getSubimage(e * 10, 60, 10, 10);
                    ctx.drawImage(newImg, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
                }
                ++e;
            }
            if (run) {
                BufferedImage newImg2 = img.getSubimage(90, 90, 10, 10);
                ctx.drawImage(newImg2, (int)((double)x + (double)i * size + (double)(1 * i)), y, (int)size, (int)size, null);
            }
            ++i;
        }
        return ctx;
    }

    public Graphics addFont(Player p, Graphics ctx) {
        int xP = p.getX() + this.x;
        int yP = p.getY() + this.y;
        if (!(xP >= -1 && xP <= Main.WIDTH + 1 || !((double)xP + this.w < -1.0) && !((double)xP + this.w > (double)(Main.WIDTH + 1)) || yP >= -1 && yP <= Main.HEIGHT + 1 || !((double)yP + this.h < -1.0) && !((double)yP + this.h > (double)(Main.HEIGHT + 1)))) {
            return ctx;
        }
        BufferedImage img = this.src == "/com/estrelsteel/game3/res/font/font.png" ? Game.fontImg : (this.src == "/com/estrelsteel/game3/res/font/font-white.png" ? Game.font2Img : Game.fontImg);
        BufferedImage newImg = img.getSubimage(this.xPos * 20, this.yPos * 10, 10, 10);
        ctx.drawImage(newImg, xP, yP, (int)this.size, (int)this.size, null);
        return ctx;
    }
}

