/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.game3;

import com.estrelsteel.game3.InputHandler;
import com.estrelsteel.game3.Main;
import com.estrelsteel.game3.MouseHandler;
import com.estrelsteel.game3.block.Block;
import com.estrelsteel.game3.block.city.City;
import com.estrelsteel.game3.block.powerplant.PowerPlant;
import com.estrelsteel.game3.character.player.Player;
import com.estrelsteel.game3.font.Font;
import com.estrelsteel.game3.gui.Gui;
import com.estrelsteel.game3.world.World;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class Game
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    private JFrame frame;
    private BufferedImage image = new BufferedImage(WIDTH, HEIGHT, 1);
    private int[] pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    public static final int SCALE = 1;
    public static final String NAME = "GNSP Server 0.1a";
    public boolean running = false;
    public int tickCount = 0;
    public int frames;
    public boolean showLine = true;
    public String text = "";
    public ImageObserver imgOb;
    public InputHandler input;
    public MouseHandler mouse;
    public JTextField field;
    public double scale = 1.0;
    public World world = new World();
    public Gui mainMenu = new Gui(this.world, 0, 0, 400.0, 400.0, 1);
    public Gui serverJoinMenu = new Gui(this.world, 0, 0, 400.0, 400.0, 2);
    public Player p = new Player(this.world, 0, 0, 0.0, 0.0, new ArrayList<City>(), this.scale);
    City city = new City(this.world, 0, 0, 60.0, 60.0, new ArrayList<String>(), this.scale);
    City city2 = new City(this.world, -300, 0, 60.0, 60.0, new ArrayList<String>(), this.scale);
    public String title = "GameNameStillPending";
    public String version = "0.4b-Alpha";
    public int versionNum = 5;
    public static int WIDTH = 400;
    public static int HEIGHT = 400;
    public List<String> tileData;
    public boolean tileDataShow = false;
    public int menuNum = 1;
    public static BufferedImage cityImg;
    public static BufferedImage waterImg;
    public static BufferedImage treeImg;
    public static BufferedImage tileImg;
    public static BufferedImage powerImg;
    public static BufferedImage mountainImg;
    public static BufferedImage grassImg;
    public static BufferedImage fontImg;
    public static BufferedImage font2Img;
    public static BufferedImage buttonImg;
    public static BufferedImage multiplayer_buttonImg;
    public static BufferedImage no_buttonImg;
    public static BufferedImage okay_buttonImg;
    public static BufferedImage singleplayer_buttonImg;
    public static BufferedImage yes_buttonImg;
    public static BufferedImage full_logoImg;
    public static BufferedImage logoImg;
    public Main main;

    public void declareTiles() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/city/city.png");
        cityImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/water/water.png");
        waterImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/tree/tree.png");
        treeImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/tile/tile.png");
        tileImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/power/power.png");
        powerImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/mountain/mountain.png");
        mountainImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/grass/grass.png");
        grassImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/font/font.png");
        fontImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/font/font-white.png");
        font2Img = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/button/button.png");
        buttonImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/button/multiplayer-button.png");
        multiplayer_buttonImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/button/no-button.png");
        no_buttonImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/button/okay-button.png");
        okay_buttonImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/button/singleplayer-button.png");
        singleplayer_buttonImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/button/yes-button.png");
        yes_buttonImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/logo/full-logo.png");
        full_logoImg = ImageIO.read(is);
        is = this.getClass().getResourceAsStream("/com/estrelsteel/game3/res/logo/logo.png");
        logoImg = ImageIO.read(is);
    }

    public Game(Main main) {
        this.main = main;
        this.input = new InputHandler(this, main);
        this.mouse = new MouseHandler(this);
        try {
            this.declareTiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addKeyListener(this.input);
        this.addMouseListener(this.mouse);
        this.setFocusable(true);
        this.setMinimumSize(new Dimension(WIDTH * 1, HEIGHT * 1));
        this.setMaximumSize(new Dimension(WIDTH * 1, HEIGHT * 1));
        this.setPreferredSize(new Dimension(WIDTH * 1, HEIGHT * 1));
        this.frame = new JFrame(String.valueOf(this.title) + " " + this.version);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(new BorderLayout());
        this.frame.add((Component)this, "Center");
        this.field = new JTextField(20);
        this.field.setMinimumSize(new Dimension(WIDTH * 1, 40));
        this.field.setMaximumSize(new Dimension(WIDTH * 1, 40));
        this.field.setPreferredSize(new Dimension(WIDTH * 1, 40));
        this.field.setLocation(0, 360);
        this.frame.setSize(400, 400);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public void moveUp() {
        if (this.p.getUP() > 0) {
            return;
        }
        this.p.setY(this.p.getY() + 5);
    }

    public void moveDown() {
        if (this.p.getDOWN() > 0) {
            return;
        }
        this.p.setY(this.p.getY() - 5);
    }

    public void moveLeft() {
        if (this.p.getLEFT() > 0) {
            return;
        }
        this.p.setX(this.p.getX() + 5);
    }

    public void moveRight() {
        if (this.p.getRIGHT() > 0) {
            return;
        }
        this.p.setX(this.p.getX() - 5);
    }

    public synchronized void start() {
        this.running = true;
        this.input = new InputHandler(this, this.main);
        this.mouse = new MouseHandler(this);
        this.mainMenu.addToMenu("/com/estrelsteel/game3/res/button/singleplayer-button.png", 100, 125, 200.0, 100.0);
        this.mainMenu.addToMenu("/com/estrelsteel/game3/res/button/multiplayer-button.png", 100, 250, 200.0, 100.0);
        this.mainMenu.addToMenu("/com/estrelsteel/game3/res/logo/logo.png", 2, 366, 32.0, 32.0);
        this.mainMenu.setSelectButtonMin(0);
        this.mainMenu.setSelectButtonMax(1);
        this.mainMenu.setMenuLayout(0);
        this.serverJoinMenu.addToMenu("/com/estrelsteel/game3/res/button/yes-button.png", 100, 125, 200.0, 100.0);
        this.serverJoinMenu.addToMenu("/com/estrelsteel/game3/res/button/no-button.png", 100, 250, 200.0, 100.0);
        this.serverJoinMenu.addToMenu("/com/estrelsteel/game3/res/logo/logo.png", 2, 366, 32.0, 32.0);
        this.serverJoinMenu.setSelectButtonMin(0);
        this.serverJoinMenu.setSelectButtonMax(1);
        this.mainMenu.setMenuLayout(0);
        this.world.generateSeed(-9999999, 9999999);
        int x1 = 60;
        while (x1 < 420) {
            int y1 = -20;
            while (y1 < 420) {
                Block tile = this.world.genBlockSeed(x1, y1, 20, 20);
                this.world.addBlock(tile);
                y1 += 20;
            }
            x1 += 20;
        }
        this.p.setName("Player");
        this.p.addCity(this.city);
        this.city.setOwner(this.p.getCharacter());
        this.city.genData("Hello");
        this.city2.genData("World!");
        this.world.addBlock(this.city);
        this.world.addBlock(this.city2);
        PowerPlant power = new PowerPlant(this.world, 0, -20, 20.0, 20.0, new ArrayList<String>(), this.scale);
        power.genData();
        this.world.addBlock(power);
        new Thread(this).start();
    }

    public synchronized void stop() {
        this.running = false;
    }

    public void run() {
        long lastTime = System.nanoTime();
        double nsPerTick = 1.6666666666666666E7;
        int ticks = 0;
        this.frames = 0;
        long lastTimer = System.currentTimeMillis();
        double delta = 0.0;
        while (this.running) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / nsPerTick;
            lastTime = now;
            boolean shouldRender = true;
            while (delta >= 1.0) {
                ++ticks;
                this.tick();
                delta -= 1.0;
                shouldRender = true;
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (shouldRender) {
                ++this.frames;
                try {
                    this.render();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (System.currentTimeMillis() - lastTimer < 1000L) continue;
            lastTimer += 1000L;
            ticks = 0;
            this.frames = 0;
            boolean bl = this.showLine = !this.showLine;
        }
    }

    public void tick() {
        ++this.tickCount;
        int i = 0;
        while (i < this.pixels.length) {
            this.pixels[i] = i + this.tickCount;
            ++i;
        }
    }

    public void render() throws IOException {
        BufferStrategy bs = this.getBufferStrategy();
        if (bs == null) {
            this.createBufferStrategy(3);
            return;
        }
        Graphics ctx = bs.getDrawGraphics();
        ctx.clearRect(0, 0, (int)((double)WIDTH * this.scale), (int)((double)HEIGHT * this.scale));
        if (this.menuNum == 0) {
            this.p.setUP(0);
            this.p.setDOWN(0);
            this.p.setRIGHT(0);
            this.p.setLEFT(0);
            int i = 0;
            while (i < this.world.getBlockWorld().size()) {
                ctx = this.world.getBlock(i).addBlock(this.p, ctx);
                ++i;
            }
            i = 0;
            while (i < this.world.getFontWorld().size()) {
                ctx = this.world.getFont(i).addFont(this.p, ctx);
                ++i;
            }
            ctx.setColor(Color.BLUE);
            WIDTH = this.getWidth();
            HEIGHT = this.getHeight();
            ctx.drawLine(WIDTH / 2, HEIGHT / 2 - 5, WIDTH / 2, HEIGHT / 2 + 5);
            ctx.drawLine(WIDTH / 2 - 5, HEIGHT / 2, WIDTH / 2 + 5, HEIGHT / 2);
            if (this.tileData != null && this.tileDataShow) {
                ctx.setColor(Color.BLACK);
                ctx.fillRect(9, 289, 382, 102);
                ctx.setColor(Color.WHITE);
                ctx.fillRect(10, 290, 380, 100);
                ctx.setColor(Color.BLACK);
                Font font = new Font(this.world, 0, 0, 0.0, 0.0, 0, 0, 10.0, this.scale);
                ctx = font.stringFont(ctx, 20, 310, "Tile Type:" + this.tileData.get(0), 10.0);
                ctx = font.stringFont(ctx, 20, 330, "Tile Name: " + this.tileData.get(1), 10.0);
                ctx = this.tileData.get(0) == "CITY" ? font.stringFont(ctx, 20, 350, "Units: " + this.tileData.get(2), 10.0) : font.stringFont(ctx, 20, 350, "Tile Info: " + this.tileData.get(2), 10.0);
                ctx = font.stringFont(ctx, 20, 370, "Tile Owner: " + this.tileData.get(3), 10.0);
            }
        } else if (this.menuNum == 1) {
            List<String> mainMenuSRC = this.mainMenu.getMenuItemsSRC();
            List<Integer> mainMenuX = this.mainMenu.getMenuItemsX();
            List<Integer> mainMenuY = this.mainMenu.getMenuItemsY();
            List<Double> mainMenuW = this.mainMenu.getMenuItemsW();
            List<Double> mainMenuH = this.mainMenu.getMenuItemsH();
            Color backColour = this.mainMenu.getBackColour();
            ctx.setColor(backColour);
            ctx.fillRect(this.mainMenu.getMenuX(), this.mainMenu.getMenuY(), (int)this.mainMenu.getMenuW(), (int)this.mainMenu.getMenuH());
            Font font = new Font(this.world, 0, 0, 0.0, 0.0, 0, 0, 40.0, this.scale);
            font.setFontColour(0);
            ctx = font.stringFont(ctx, 120, 50, "GNSP", 40.0);
            ctx = font.stringFont(ctx, 310, 380, this.version, 7.0);
            int i = 0;
            while (i < mainMenuSRC.size()) {
                InputStream is = this.getClass().getResourceAsStream(mainMenuSRC.get(i));
                ctx.drawImage(ImageIO.read(is), mainMenuX.get(i), mainMenuY.get(i), mainMenuW.get(i).intValue(), mainMenuH.get(i).intValue(), null);
                ++i;
            }
            ctx.drawImage(this.image, this.frames, this.frames, 0, 0, this.imgOb);
            ctx.setColor(Color.RED);
            ctx.drawLine(100, 250, 300, 350);
            ctx.drawLine(300, 250, 100, 350);
            if (this.mainMenu.getSelectButton() == 0) {
                ctx.setColor(Color.RED);
                ctx.fillRect(80, 170, 10, 10);
            } else if (this.mainMenu.getSelectButton() == 1) {
                ctx.setColor(Color.RED);
                ctx.fillRect(80, 295, 10, 10);
            }
        } else if (this.menuNum == 2) {
            List<String> menuSRC = this.serverJoinMenu.getMenuItemsSRC();
            List<Integer> menuX = this.serverJoinMenu.getMenuItemsX();
            List<Integer> menuY = this.serverJoinMenu.getMenuItemsY();
            List<Double> menuW = this.serverJoinMenu.getMenuItemsW();
            List<Double> menuH = this.serverJoinMenu.getMenuItemsH();
            Color backColour = this.serverJoinMenu.getBackColour();
            ctx.setColor(backColour);
            ctx.fillRect(this.serverJoinMenu.getMenuX(), this.serverJoinMenu.getMenuY(), (int)this.serverJoinMenu.getMenuW(), (int)this.serverJoinMenu.getMenuH());
            Font font = new Font(this.world, 0, 0, 0.0, 0.0, 0, 0, 40.0, this.scale);
            font.setFontColour(0);
            ctx = font.stringFont(ctx, 120, 50, "Run a server???", 10.0);
            int i = 0;
            while (i < menuSRC.size()) {
                ctx.drawImage(ImageIO.read(new File(menuSRC.get(i))), menuX.get(i), menuY.get(i), menuW.get(i).intValue(), menuH.get(i).intValue(), this.imgOb);
                ++i;
            }
            if (this.serverJoinMenu.getSelectButton() == 0) {
                ctx.setColor(Color.RED);
                ctx.fillRect(80, 170, 10, 10);
            } else if (this.serverJoinMenu.getSelectButton() == 1) {
                ctx.setColor(Color.RED);
                ctx.fillRect(80, 295, 10, 10);
            }
        }
        ctx.dispose();
        bs.show();
    }
}

