/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.game3.block;

import com.estrelsteel.game3.character.player.Player;
import com.estrelsteel.game3.location.Location;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;

public class Block
extends Location {
    int x = this.getX();
    int y = this.getY();
    int w = this.getW();
    int h = this.getH();
    List<String> data = new ArrayList<String>();
    boolean c;
    String src;
    boolean s;

    public Block(int xN, int yN, int wN, int hN, String srcN, boolean cN, List<String> dataN, boolean sN) {
        super(xN, yN, wN, hN);
        this.src = srcN;
        this.c = cN;
        this.s = sN;
    }

    public boolean getCollision() {
        return this.c;
    }

    public String getSRC() {
        return this.src;
    }

    public GraphicsContext addBlock(Player p, GraphicsContext ctx) {
        int xP = p.getX() + this.x;
        int yP = p.getY() + this.y;
        if (!(!this.s || xP >= -1 && xP <= 401 || xP + this.w >= -1 && xP + this.w <= 401 || yP >= -1 && yP <= 401 || yP + this.h >= -1 && yP + this.h <= 401)) {
            return ctx;
        }
        ctx.drawImage(new Image(this.src), (double)xP, (double)yP, (double)this.w, (double)this.h);
        if (!this.c) {
            return ctx;
        }
        if ((xP >= 195 && xP <= 205 || xP + this.w >= 195 && xP <= 195) && (yP >= 190 && yP <= 200 || yP + this.h >= 190 && yP + this.h <= 200)) {
            p.increaseUP();
        } else if ((xP >= 195 && xP <= 205 || xP + this.w >= 195 && xP <= 195) && (yP >= 200 && yP <= 210 || yP + this.h >= 200 && yP + this.h <= 210)) {
            p.increaseDOWN();
        } else if ((xP >= 200 && xP <= 210 || xP + this.w >= 200 && xP + this.w <= 210) && (yP >= 195 && yP <= 205 || yP + this.h >= 195 && yP <= 195)) {
            p.increaseRIGHT();
        } else if ((xP >= 190 && xP <= 200 || xP + this.w >= 190 && xP + this.w <= 200) && (yP >= 195 && yP <= 205 || yP + this.h >= 195 && yP <= 195)) {
            p.increaseLEFT();
        }
        return ctx;
    }

    public List<String> getBlockCollisionData(Player p) {
        int xP = p.getX() + this.x;
        int yP = p.getY() + this.y;
        int wP = this.w;
        int hP = this.h;
        int i = 1;
        while (i * 20 <= this.w) {
            wP = i * 20;
            hP = i * 20;
            if ((xP >= 195 && xP <= 205 || xP + wP >= 195 && xP <= 195) && (yP >= 190 && yP <= 200 || yP + hP >= 190 && yP + hP <= 200)) {
                return this.data;
            }
            if ((xP >= 195 && xP <= 205 || xP + wP >= 195 && xP <= 195) && (yP >= 200 && yP <= 210 || yP + hP >= 200 && yP + hP <= 210)) {
                return this.data;
            }
            if ((xP >= 200 && xP <= 210 || xP + wP >= 200 && xP + wP <= 210) && (yP >= 195 && yP <= 205 || yP + hP >= 195 && yP <= 195)) {
                return this.data;
            }
            if ((xP >= 190 && xP <= 200 || xP + wP >= 190 && xP + wP <= 200) && (yP >= 195 && yP <= 205 || yP + hP >= 195 && yP <= 195)) {
                return this.data;
            }
            ++i;
        }
        return null;
    }

    public List<String> getBlockData() {
        return this.data;
    }

    public void setBlockData(List<String> dataN) {
        this.data = dataN;
    }

    public void genBlockData(String type) {
        if (type == "CITY") {
            this.data.add("CITY");
            this.data.add("City");
            this.data.add("A city");
            this.data.add("CHARACTER");
        } else if (type == "TILE") {
            this.data.add("TILE");
            this.data.add("Tile");
            this.data.add("A tile");
            this.data.add("NULL");
        }
    }

    public void genBlockData(String type, String name) {
        if (type == "CITY") {
            this.data.add("CITY");
            this.data.add(name);
            this.data.add("A city");
            this.data.add("CHARACTER");
        } else if (type == "TILE") {
            this.data.add("TILE");
            this.data.add(name);
            this.data.add("A tile");
            this.data.add("NULL");
        }
    }

    public void outBlockData() {
        System.out.println(this.data.get(0));
        System.out.println(this.data.get(1));
        System.out.println(this.data.get(2));
        System.out.println(this.data.get(3));
    }
}

