/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.game3;

import com.estrelsteel.game3.block.Block;
import com.estrelsteel.game3.character.player.Player;
import com.estrelsteel.game3.city.City;
import com.estrelsteel.game3.world.World;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Main
extends Application {
    public Player p = new Player(0, 0, 0, 0, new ArrayList<City>());
    City city = new City(0, 0, 60, 60, new ArrayList<String>());
    public String title = "PassionProject";
    public String version = "0.1a-Alpha-JAVA";
    public World world = new World();
    public Canvas can = new Canvas(400.0, 400.0);
    public GraphicsContext ctx = this.can.getGraphicsContext2D();
    public VBox pane;

    public void draw() {
        this.ctx.clearRect(0.0, 0.0, 400.0, 400.0);
        this.p.setUP(0);
        this.p.setDOWN(0);
        this.p.setRIGHT(0);
        this.p.setLEFT(0);
        int i = 0;
        while (i < this.world.getBlockWorld().size()) {
            this.ctx = this.world.getBlock(i).addBlock(this.p, this.ctx);
            ++i;
        }
        this.ctx.fillOval(190.0, 190.0, 20.0, 20.0);
        this.pane.getChildren().clear();
        this.pane.getChildren().add((Object)this.can);
    }

    public void moveUp() {
        if (this.p.getUP() > 0) {
            return;
        }
        this.p.setY(this.p.getY() + 5);
        this.draw();
    }

    public void moveDown() {
        if (this.p.getDOWN() > 0) {
            return;
        }
        this.p.setY(this.p.getY() - 5);
        this.draw();
    }

    public void moveLeft() {
        if (this.p.getLEFT() > 0) {
            return;
        }
        this.p.setX(this.p.getX() + 5);
        this.draw();
    }

    public void moveRight() {
        if (this.p.getRIGHT() > 0) {
            return;
        }
        this.p.setX(this.p.getX() - 5);
        this.draw();
    }

    public void start(Stage stage) {
        this.pane = new VBox();
        Scene scene = new Scene((Parent)this.pane, 400.0, 400.0);
        this.p.addCity(this.city);
        this.world.addBlock(this.city);
        this.world.addBlock(new Block(60, 0, 20, 20, "/com/estrelsteel/game3/res/tile/tile.png", false, new ArrayList<String>(), false));
        this.world.addBlock(new Block(60, 20, 20, 20, "/com/estrelsteel/game3/res/tile/tile.png", false, new ArrayList<String>(), false));
        this.world.addBlock(new Block(60, 40, 20, 20, "/com/estrelsteel/game3/res/tile/tile.png", false, new ArrayList<String>(), false));
        this.draw();
        scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                switch (ke.getCode()) {
                    case W: {
                        Main.this.moveUp();
                        break;
                    }
                    case S: {
                        Main.this.moveDown();
                        break;
                    }
                    case A: {
                        Main.this.moveLeft();
                        break;
                    }
                    case D: {
                        Main.this.moveRight();
                        break;
                    }
                    case O: {
                        Main.this.moveUp();
                        break;
                    }
                    case L: {
                        Main.this.moveDown();
                        break;
                    }
                    case K: {
                        Main.this.moveLeft();
                        break;
                    }
                    case SEMICOLON: {
                        Main.this.moveRight();
                        break;
                    }
                    case UP: {
                        Main.this.moveUp();
                        break;
                    }
                    case DOWN: {
                        Main.this.moveDown();
                        break;
                    }
                    case LEFT: {
                        Main.this.moveLeft();
                        break;
                    }
                    case RIGHT: {
                        Main.this.moveRight();
                        break;
                    }
                }
            }
        });
        stage.setScene(scene);
        stage.setTitle(String.valueOf(this.title) + " " + this.version);
        stage.setResizable(false);
        stage.show();
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

